using System;
using System.IO;

public class Program
{
  public static void Main(String[] args)
  {
    if(args.Length < 1)
    {
      Console.WriteLine("Wywołanie programu: Program plik");
      return;
    }
    String plik = args[0];
    FileInfo fi;

    try
    {
      fi = new FileInfo(plik);
    }
    catch(ArgumentException)
    {
      Console.WriteLine(
        "Nazwa {0} zawiera nieprawidłowe znaki.", plik);
      return;
    }
    
    if(fi.Exists)
    {
      Console.WriteLine("Plik {0} już istnieje", plik);
      return;
    }

    FileStream fs;
    try
    {
      fs = fi.Create();
    }
    catch(Exception)
    {
      Console.WriteLine("Plik {0} nie może być utworzony.", plik);
      return;
    }
    /*
      tutaj można wykonać operacje na pliku
    */
    fs.Close();
    Console.WriteLine("Plik {0} został utworzony.", plik);
  }
}
